#!/bin/bash
#
# Part of Micetro
#

DHCP_SCRIPTS="/etc/init.d/dhcpd /etc/init.d/dhcp3 /etc/init.d/dhcp3-server /etc/init.d/dhcp4-server /etc/init.d/isc-dhcp-server /bin/systemctl"
DHCP_BINARIES="/usr/sbin/dhcpd /usr/sbin/dhcp3 /usr/sbin/dhcpd3"


if [ -z $1 ]
then
	# if no argument provided restart the dhcp server
	for INITSCRIPT in $DHCP_SCRIPTS
	do
		if [ $INITSCRIPT == "/bin/systemctl" ]
		then
			SYSCTL_SERVICE="dhcpd"
		else
			SYSCTL_SERVICE=""
		fi			
		if [ -x $INITSCRIPT ]
		then
			$INITSCRIPT stop $SYSCTL_SERVICE
			$INITSCRIPT start $SYSCTL_SERVICE
			exit $?
		fi
	done
	echo "Error: Unable to find the dhcpd init script to restart the dhcpd service"
	exit 254
fi

case "$1" in
	"-config")
		for BINARY in $DHCP_BINARIES
		do
			if [ -x $BINARY ]
			then
				shift
				$BINARY -t $@
				exit $?
			fi
		done
		# if no binary found return an error
		echo "Error: Unable to find the dhcpd binary to check for errors"
		exit 254
		
	;;

	*)	
		for INITSCRIPT in $DHCP_SCRIPTS
		do
			if [ $INITSCRIPT == "/bin/systemctl" ]
			then
				SYSCTL_SERVICE="dhcpd"
			else
				SYSCTL_SERVICE=""
			fi			
			if [ -x $INITSCRIPT ]
			then
				$INITSCRIPT $@ $SYSCTL_SERVICE
				exit $?
			fi
		done
	;;
esac

# if nothing found return an error
echo "Error: Unable to find the dhcpd init script"
exit 254

