#!/usr/bin/env python3
#
# A simple example of how to use REST commands with mmWSClient
# For a list of available operations, refer to:
# https://docs.menandmice.com/en/latest/guides/user-manual/rest_api/
#
from mmWSClient import Client


webServer = "micetro.demo"
username = "a_user"
password = "secret"
###JWD
webServer = "http://localhost:8111/mmws"
username = "administrator"
password = "administrator"

print("Connecting to Micetro web server:", webServer)
client = Client(server=webServer, username=username, password=password)

# ----- Examples using REST like commands -----
# Example - Get all users
users = client.get("users")
print("All users:")
print(users)

# Example - Get a single user
admin = client.get("users", "Administrator")
print()
print("Administrator:")
print(admin)

# Example - creating a user
user_data = {
    "name": "John",
    "fullName": "John Doe",
    "email": "john@acme.com.",
    "authenticationType": "Internal",
    "password": "this is a password",
}
new_user_ref = client.post("users", user=user_data, saveComment="creating a user")["ref"]

# Example - get this new user
new_user = client.get("users", new_user_ref)
print()
print("New user:")
print(new_user)

# Example - find all users there name start with "John", but only limit the result to two
users_ind = client.get("users", filter="name= ^John", limit=2)

# Example - delete the new user
print()
print("deleting the newly added user:", new_user_ref)
client.delete("users", new_user_ref)
