#!/usr/bin/env python
import subprocess
import sys
import os


def install_requirements():
    subprocess.check_call(
        [sys.executable, "-m", "pip", "install", "-r", "requirements.txt"]
    )


def install_package():
    subprocess.check_call([sys.executable, "setup.py", "install"])


if __name__ == "__main__":
    if not os.path.exists("requirements.txt"):
        print("requirements.txt not found.")
        sys.exit(1)
    install_requirements()
    install_package()
