--- change the 'abc123' for the user below and then
--- execute with the script like
--- psql.exe -Upostgres -f create_mmsuite_db.sql

\prompt 'This script will drop the mmsuite database and the mmsuitedbuser! Are you sure? [y/n]' y

select ('y' = :'y') as is_yes \gset

\if :is_yes
     --- creates the mmsuite DB and a user mmsuitedbuser with password abc123
     ---
    \echo terminating connections to mmsuite database
    --- drop all connection postgresql 12.8 
    SELECT pg_terminate_backend(pg_stat_activity.pid) FROM pg_stat_activity WHERE pg_stat_activity.datname = 'mmsuite' AND pid <> pg_backend_pid();
    \echo dropping database mmsuite
    --- drop the mmsuite DB
    drop database mmsuite;
    \echo dropping user mmsuitedbuser
    --- drop user
    drop user mmsuitedbuser;
    \echo creating new mmsuite DB 
    --- create new mmsuite DB 
    CREATE DATABASE mmsuite ENCODING = 'UTF8' LC_CTYPE = 'C' LC_COLLATE='C' TEMPLATE template0;
    \echo creating new mmsuitedbuser and grant all privileges and Replication to it
    --- create mmSuiteDBUser
    create user mmsuitedbuser with password 'abc123';
    --- grant all privileges to mmSuiteDBUser
    grant all privileges on database mmsuite to mmsuitedbuser;
    ALTER USER mmsuitedbuser WITH Replication;
    \echo Done!
\else
    \echo Stop!
\endif
